package jamezo97.clonecraft.network;

import java.util.Iterator;

import jamezo97.clonecraft.Reflect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

public class NetworkHandler implements IPacketHandler{

	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
		if(packet != null){
			if(packet.channel.equals("CloneCraftServer") || packet.channel.equals("CloneCraftClient")){
				Handler.createAndUsePacket(manager, packet, player);
			}
		}
	}
	
    public static void sendPacketToServer(Packet packet){
    	PacketDispatcher.sendPacketToServer(packet);
    }
    
    public static void sendPacketToPlayer(Packet packet, Player player){
    	PacketDispatcher.sendPacketToPlayer(packet, player);
    }
    
    public static void sendPacketToAllAround(double X, double Y, double Z, double range, int dimensionId, Packet packet){
    	PacketDispatcher.sendPacketToAllAround(X, Y, Z, range, dimensionId, packet);
    }

    public static void sendPacketToAllInDimension(Packet packet, int dimId){
    	PacketDispatcher.sendPacketToAllInDimension(packet, dimId);
    }

    public static void sendPacketToAllPlayers(Packet packet){
    	PacketDispatcher.sendPacketToAllPlayers(packet);
    }
    
    public static boolean sendPacketToPlayersWatching(Entity entity, Packet packet){
    	World worldE = entity.worldObj;
    	if(worldE != null && worldE instanceof WorldServer){
    		WorldServer world = (WorldServer)worldE;
    		EntityTracker tracker = world.getEntityTracker();
    		if(tracker != null){
    			IntHashMap map = Reflect.get(tracker, Reflect.trackedEntityIDs, IntHashMap.class);
    			if(map != null){
    				Object o = map.lookup(entity.entityId);
    				if(o != null && o instanceof EntityTrackerEntry){
    					((EntityTrackerEntry)o).sendPacketToAllTrackingPlayers(packet);
    					return true;
    				}else{
    					
    				}
    			}
    		}
    	}
    	return false;
    }
    
    public static boolean sendPacketToPlayersWatchingExcluding(Entity entity, Packet packet, EntityPlayer excluding){
    	World worldE = entity.worldObj;
    	if(worldE != null && worldE instanceof WorldServer){
    		WorldServer world = (WorldServer)worldE;
    		EntityTracker tracker = world.getEntityTracker();
    		if(tracker != null){
    			IntHashMap map = Reflect.get(tracker, Reflect.trackedEntityIDs, IntHashMap.class);
    			if(map != null){
    				Object o = map.lookup(entity.entityId);
    				if(o != null && o instanceof EntityTrackerEntry){
    					EntityTrackerEntry entry = ((EntityTrackerEntry)o);
    					Iterator iterator = entry.trackingPlayers.iterator();
    			        while (iterator.hasNext()){
    			            EntityPlayerMP entityplayermp = (EntityPlayerMP)iterator.next();
    			            if(entityplayermp != excluding){
    			            	entityplayermp.playerNetServerHandler.sendPacketToPlayer(packet);
    			            }
    			        }
    					return true;
    				}
    			}
    		}
    	}
    	return false;
    }

	public static void sendPacketToPlayers(EntityPlayer[] players, Packet packet) {
		for(int a = 0; a < players.length; a++){
			PacketDispatcher.sendPacketToPlayer(packet, (Player)players[a]);
		}
	}

    
}
